package com.izjun.sms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/*
 * @author 掌骏传媒
 * @version 1.0
 * @date 2023/8/9 10:53
 */
public class SmsUtils {
    /**
     * 获取时间戳
     * @return 13位时间戳
     **/ 
    public static long getTimestamp()
    {
        return System.currentTimeMillis();
    }

    /**
     * 生成sign值
     * @param account 账号
     * @param password 密码
     * @param timestamp 时间戳
     * @return sign
     **/ 
    public static String generateSign(String account, String password, long timestamp) throws NoSuchAlgorithmException {
        String value = account + timestamp + md5(password);
        return md5(value);
    }

    /**
     * 生成sign值
     * @param account 账号
     * @param password 密码
     * @return sign
     **/
    public static String generateSign(String account, String password) throws NoSuchAlgorithmException {
        long timestamp = getTimestamp();
        return generateSign(account, password, timestamp);
    }

    /**
     * 计算 MD5 值
     *
     * @param str 字符串
     * @return MD5 值
     * @throws NoSuchAlgorithmException
     */
    public static String md5(String str) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(str.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString((item & 0xFF) | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    /**
     * 发送 POST 请求
     *
     * @param url  服务器地址
     * @param data 请求参数
     * @return 响应内容
     * @throws IOException
     */
    public static String post(String url, String data) throws IOException {
        HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream()) {
            os.write(data.getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        StringBuilder response = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8))) {
            String line;
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }
}
