package com.izjun.sms;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

/*
 * @author 掌骏传媒
 * @version 1.0
 * @date 2023/8/9 10:53
 */
public class SmsSend {
    private String userName = "";
    private String password = "";
    private String address = "";

    /**
     * 构造方法，传入账号，密码，接口ip端口或域名，例如：192.168.2.1:8080或sms.test.com
     * @param userName 账号
     * @param password 密码
     * @param address 接口ip端口或域名 
     **/ 
    public SmsSend(String userName, String password, String address)
    {
        this.userName = userName;
        this.password = password;
        this.address = address;
    }

    /**
     * 群发短信，完整参数
     * @param phoneList 手机号码列表
     * @param content 短信内容
     * @param sendTime 定时时间
     * @param extcode 扩展码
     * @param callData 用户回传数据
     * @return json字符串
     **/ 
    public String sendSmsMass(List<String> phoneList, String content, String sendTime, String extcode, String callData) throws NoSuchAlgorithmException, IOException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/sendMessageMass";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);
        data.put("phoneList", phoneList);
        data.put("content", content);
        data.put("sendTime", sendTime);
        data.put("extcode", extcode);
        data.put("callData", callData);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }

    /**
     * 群发定时短信
     * @param phoneList 手机号码列表
     * @param content 短信内容
     * @param sendTime 定时时间
     * @return json字符串
     **/
    public String sendSmsMass(List<String> phoneList, String content, String sendTime) throws NoSuchAlgorithmException, IOException {
        // 发送请求
        return sendSmsMass(phoneList, content, sendTime, null, null);
    }

    /**
     * 群发短信，携带extcode与callData
     * @param phoneList 手机号码列表
     * @param content 短信内容
     * @param extcode 扩展码
     * @param callData 用户回传数据
     * @return json字符串
     **/
    public String sendSmsMass(List<String> phoneList, String content, String extcode, String callData) throws NoSuchAlgorithmException, IOException {
        // 发送请求
        return sendSmsMass(phoneList, content, null, extcode, callData);
    }

    /**
     * 群发短信
     * @param phoneList 手机号码列表
     * @param content 短信内容
     * @return json字符串
     **/
    public String sendSmsMass(List<String> phoneList, String content) throws NoSuchAlgorithmException, IOException {
        // 发送请求
        return sendSmsMass(phoneList, content, null, null, null);
    }

    /**
     * 发送一对一定时短信
     * @param messageList 手机号码与内容列表
     * @param sendTime 定时时间
     * @return json字符串
     **/
    public String sendSmsOne(List<Map<String, String>> messageList, String sendTime) throws NoSuchAlgorithmException, IOException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/sendMessageOne";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);
        data.put("messageList", messageList);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }

    /**
     * 发送一对一定时短信
     * @param messageList 手机号码与内容列表
     * @return json字符串
     **/
    public String sendSmsOne(List<Map<String, String>> messageList) throws NoSuchAlgorithmException, IOException {
        return sendSmsOne(messageList, null);
    }

    /**
     * 获取状态报告
     * @return json字符串
     **/
    public String getReport() throws NoSuchAlgorithmException, IOException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/getReport";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }

    /**
     * 获取上行回复
     * @return json字符串
     **/
    public String getUpstream() throws NoSuchAlgorithmException, IOException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/getUpstream";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }

    /**
     * 获取余额
     * @return json字符串
     **/
    public String getBalance() throws NoSuchAlgorithmException, IOException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/getBalance";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }

    /**
     * 提交短信模板
     * @param content 模板内容
     * @return json字符串
     **/
    public String createTemplate(String content) throws IOException, NoSuchAlgorithmException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/createTemplate";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);
        data.put("content", content);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }

    /**
     * 查询短信模板
     * @return json字符串
     **/
    public String queryTemplate() throws NoSuchAlgorithmException, IOException {
        // 获取时间戳
        long timestamp = SmsUtils.getTimestamp();
        // 获取sign
        String sign = SmsUtils.generateSign(userName, password, timestamp);
        // 获取url
        String url = "http://" + address + "/sms/api/queryTemplates";

        // 请求数据
        Map<String, Object> data = new HashMap<>();
        data.put("userName", userName);
        data.put("timestamp", timestamp);
        data.put("sign", sign);

        // 转换为json字符串
        String json = new JSONObject(data).toString();

        // 发送请求
        return SmsUtils.post(url, json);
    }
}
